<%@ Page Title="" Language="C#" MasterPageFile="~/Registry.master" AutoEventWireup="true" CodeFile="LabKitOrders.aspx.cs" Inherits="LabKitOrders" %>
 <%@ Import Namespace="AntiXssEnc=Microsoft.Security.Application" %>
<%@ Register TagPrefix="asp" Namespace="AjaxControlToolkit" Assembly="AjaxControlToolkit"%>

<asp:Content ID="Content1" ContentPlaceHolderID="head" Runat="Server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder" Runat="Server">

    <script type = "text/javascript">

        $(document).ready(function() {
            if ($('select.criteria').length > 0) {
                if ($('select.criteria').find(":selected").val() == "") {
                    $('#<%= ButtonSearch.ClientID %>').attr('disabled', 'disabled');
                    $('#ButtonClear').attr('disabled', 'disabled');

                    $("#<%= TextBoxSearchCriteria.ClientID%>").hide();
                    $("#<%= DropDownListFacility.ClientID%>").hide();
                }
                else {
                    $('#<%= ButtonSearch.ClientID %>').removeAttr('disabled');
                    $('#ButtonClear').removeAttr('disabled');

                    if ($('select.criteria').find(":selected").val() == "LAST_NAME") {
                        $("#<%= TextBoxSearchCriteria.ClientID%>").show();
                        $("#<%= DropDownListFacility.ClientID%>").hide();
                    }
                    else if ($('select.criteria').find(":selected").val() == "FACILITY") {
                        $("#<%= TextBoxSearchCriteria.ClientID%>").hide();
                        $("#<%= DropDownListFacility.ClientID%>").show();
                    }
                }

            }

            $('select.criteria').change(function() {

                $('#<%= TextBoxSearchCriteria.ClientID %>').val('');
                $('#<%= DropDownListFacility.ClientID%>').val('');
                
                if ($(this).val() == "") {
                    $('#<%= ButtonSearch.ClientID %>').attr('disabled', 'disabled');
                    $('#ButtonClear').attr('disabled', 'disabled');

                    $("#<%= TextBoxSearchCriteria.ClientID%>").hide();
                    $("#<%= DropDownListFacility.ClientID%>").hide();
                }
                else {
                    $('#<%= ButtonSearch.ClientID %>').removeAttr('disabled');
                    $('#ButtonClear').removeAttr('disabled');

                    if ($(this).val() == "LAST_NAME") {
                        $("#<%= TextBoxSearchCriteria.ClientID%>").show();
                        $("#<%= DropDownListFacility.ClientID%>").hide();
                    }
                    else if ($(this).val() == "FACILITY") {
                        $("#<%= TextBoxSearchCriteria.ClientID%>").hide();
                        $("#<%= DropDownListFacility.ClientID%>").show();
                    }
                }

            });

        });

        function ClearSearchCriteria () {
            control = document.getElementById("<%= TextBoxSearchCriteria.ClientID %>");
            if (control != null)
            {
                control.value = "";
            }
            control = document.getElementById("<%= DropDownListFacility.ClientID %>");
            if (control != null)
            {
                control.value = "";
            }
        }

    </script>
    <div class="breadcrumb">
              <asp:Label SkinID="DataLabel" ID = "BreadCrumbLabel" runat="server" Text="My Tasks > Lab Kits > New" />
              <br />
    </div>
 
     <div class = "excludeSaveWarnings">
        <br />
        <asp:Label SkinID="DataLabel" ID="LabelSearchCriteria" runat="server" 
            AssociatedControlID="TextBoxSearchCriteria">
            Filter by:
        </asp:Label>
        <asp:DropDownList ID="DropDownFilterBy" runat="server" CssClass = "criteria">
            <asp:ListItem Selected="True" 
                Text="(Select value)" 
                value="">
            </asp:ListItem>
            <asp:ListItem 
                Text="Last Name" 
                value="LAST_NAME">
            </asp:ListItem>
            <asp:ListItem 
                Text="Site/Facility" 
                value="FACILITY">
            </asp:ListItem>
        </asp:DropDownList>
         
        <asp:TextBox ID="TextBoxSearchCriteria" runat="server" Width="200px"></asp:TextBox>
        <asp:DropDownList ID="DropDownListFacility"  
            runat="server" Width="500px" CssClass = "criteriaFacility" 
            DataSourceID="ObjectDataSourceVAMCs" AppendDataBoundItems="true" 
            DataTextField="Value" DataValueField="Key">
            <asp:ListItem Value="" Text="(Type to Search)" Selected="True"></asp:ListItem>
            </asp:DropDownList>
        <asp:ScriptManager ID="ScriptManager1" runat="server" />
        <asp:ListSearchExtender ID="ListSearchExtenderFacility" QueryTimeout="2"
            runat="server" TargetControlID="DropDownListFacility" 
            QueryPattern="Contains">
        </asp:ListSearchExtender>
        &nbsp;
        &nbsp;
        <asp:Button ID="ButtonSearch" runat="server" Text=" &nbsp;&nbsp;Go&nbsp;&nbsp; " OnClick = "ButtonOK_Click"
            />
        &nbsp;
        <asp:Button ID="ButtonClear" runat="server" Text=" Clear " 
             onclick="ButtonClear_Click" OnClientClick="javascript:ClearSearchCriteria()"  />
    </div>    
    <asp:GridView ID="GridLabKitOrders" runat="server" AllowPaging="True" 
        AutoGenerateColumns="False" DataSourceID="ObjectDataSource1" Width="80%" DataKeyNames="InstitutionId,KitTypeId" 
         AllowSorting="true" OnRowCommand="SelectPatients">
        <Columns>
            <asp:TemplateField HeaderText="Facility" SortExpression="Facility">
                <ItemTemplate>
                <asp:Label SkinID="DataLabel" runat="server" ID="InstName" Text='<%#AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("Facility"))) %>'></asp:Label>
                        <asp:Repeater ID="Repeater1" runat="server" DataSource='<%#Eval("Patient") %>' OnItemCreated="ChangeGroupingText">
                        <HeaderTemplate><asp:Panel ID="PanelPatient" runat="server"  ForeColor="Black"   Font-Bold="true" GroupingText="Patients requiring kit" BorderStyle="None"> </asp:Panel></HeaderTemplate>
                        <ItemTemplate>
                            <div style="padding-left:20px; padding-top:5px">
                            <li><asp:Label SkinID="DataLabel" ID="Label2" runat="server" Text='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Container.DataItem)) %>'></asp:Label></li>
                            </div>
                        </ItemTemplate>
                        </asp:Repeater>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:BoundField DataField="StationNumber" HeaderText="Site Number" 
                SortExpression="StationNumber" />
            <asp:BoundField DataField="KitTypeCd" HeaderText="Kit Type" 
                SortExpression="KitTypeCd" />
            <asp:BoundField DataField="Count" HeaderText="Number of Kits" 
                SortExpression="Count" /> 
            <asp:ButtonField ButtonType = "Button" Text = "Select" CommandName = "Details"  />
        </Columns>
    </asp:GridView>
    <br />
    <asp:Button ID="buttonPrint" runat="server" Text=" Print Lab Kits Required Report " onclick="buttonPrint_Click" Visible="true"/>
    
    <asp:ObjectDataSource ID="ObjectDataSource1" runat="server" 
        SelectMethod="GetPatientsForNewKitOrders" 
        TypeName="VeteransAffairs.Registries.BusinessManager.LabKitOrderManager"  OnSelected="ChangeEmptyDataText"
        SelectCountMethod="GetPatientsForNewKitOrders" 
            StartRowIndexParameterName="startRow" 
            MaximumRowsParameterName="maxRows" 
            SortParameterName="sort"
            EnablePaging="True" 
                OldValuesParameterFormatString="original_{0}">
    <SelectParameters> 
        <asp:ControlParameter Name = "lastName" ControlID = "TextBoxSearchCriteria" DefaultValue = "" />
        <asp:ControlParameter Name = "facilityId" ControlID = "DropDownListFacility" 
        propertyname="SelectedValue" DefaultValue = "" />
   </SelectParameters>     
    </asp:ObjectDataSource>
    <asp:ObjectDataSource ID="ObjectDataSourceVAMCs" runat="server" 
        SelectMethod="GetInsitutionList" 
        TypeName="VeteransAffairs.Registries.BusinessManager.Utilities.DropDownLists">
    </asp:ObjectDataSource>    
</asp:Content>

